varying vec2 		texcoord;

uniform sampler2D 	dif0,

#ifdef _HEIGHTMAP_
					bmp0,
#endif
					noisemap;
uniform vec2		fresnel0,
					spec0;
uniform vec4		dcolor0,
					scolor0;
uniform vec2		dscale0,
					bscale0;
uniform vec2		dofs0,
					bofs0;
uniform float 		scatterlevel;
uniform float 		scatterRed;
uniform float 		backScatter;
uniform float		wFar;

uniform float		matID;

#ifdef VEGETATION
	#ifndef BSET
		#ifndef MSET
			varying vec3	vgColor;
		#endif
	#endif
#endif
	
#ifdef LAYER1
	
	uniform sampler2D 	lmask;
	varying vec3		vertColor;
	
#endif 	
	
#ifdef ALPHATEST

	uniform float 		alphalevel;
	varying float		alphaFade;
	
#endif

#ifdef PSYSTEM

	varying float 	life;
	varying float	cosa,
			sina;
					
#else

	#ifdef BSET

		varying vec4 pnormal;
		varying vec4 pcolor;

	#else
	
		#ifdef MSET
		varying vec4 pcolor;
		uniform float terrainColorAmount;
		#else
			varying float occlusion; 
		#endif
		
		varying mat3	TBN;
		
	#endif
		
#endif				


#ifdef _HEIGHTMAP_

	uniform sampler2D	baseTex;
	uniform sampler2D	cmask;
	varying float	vSlope;
	varying vec2 	baseCoords;
	
#endif

varying vec4 		curpos,
#ifdef _HEIGHTMAP_
					pos,
#endif
					prev;
uniform float		vScale;
uniform float 		fade;

varying vec2 	depth;
varying float	scatterMask;

vec2 encode(vec3 n)
{
	n=normalize(n);
    float f = sqrt(8.0*n.z+8.0);
    return n.xy / f + 0.5;
}

void main()
{
	#ifdef PSYSTEM
	
	if(life<=0.0)
		discard;
			
	#endif
	
	vec2 screenCoords=prev.xy;

	vec4 	fdcolor,
			fbcolor;
	vec3	fnormal;
	vec2	fspec,
			ffresnel;
			
	#ifdef LAYER1
	
		vec3 mask=texture2D(lmask,texcoord.st).rgb;
		mask.r=min(1.0,mask.r+mask.g+mask.b);
	
	#endif
			
	#ifndef _HEIGHTMAP_		
		fdcolor=texture2D(dif0,texcoord.st*dscale0+dofs0);
		fdcolor.rgb=pow(fdcolor.rgb,vec3(2.2))*dcolor0.rgb;
	#endif
	
	#ifdef ALPHATEST

		#ifdef PSYSTEM
			float alpha=fdcolor.a*life;
			if(alpha<=alphalevel)
				discard;
		#else
			#ifdef BSET
				float alpha=texture2D(noisemap,screenCoords.st).r;
				if(alpha>pcolor.w)
					discard;
			#else
				#ifdef MSET
					float alpha=texture2D(noisemap,screenCoords.st*5.0).r;
					if(alpha>fade)
						discard;
				#else
					#ifdef _HEIGHTMAP_
					#else
						#ifdef SKINNING
						#else
							#ifndef _NOT_INSTANCED_
								float alpha=texture2D(noisemap,screenCoords.st*5.0).r;
								if(alpha>alphaFade)
									discard;
							#else
								float alpha=texture2D(noisemap,screenCoords.st*5.0).r;
								if(alpha>fade)
									discard;
							#endif
						#endif
					#endif
				#endif
			#endif
			
			#ifdef BSET
				if(fdcolor.a<=alphalevel)
					discard;
			#else
				if(fdcolor.a<=mix(alphalevel,alphalevel*0.8,clamp(curpos.z*25000.0-4500.0,0.0,1.0)))
					discard;
			#endif
		#endif
		
	#endif

	#ifdef BSET
	
	#else
		#ifdef _HEIGHTMAP_
			fbcolor=texture2D(bmp0,texcoord.st*bscale0+bofs0);
			fnormal.xy=(fbcolor.xy*2.0-1.0);
			ffresnel.y=fresnel0.y*fbcolor.z;
			ffresnel.x=1.0;
			//ffresnel.x=fresnel0.x*fbColor.a;
		#else
			fnormal.xyz=vec3(0.0,0.0,1.0);
			ffresnel.xy=fresnel0.xy*vec2(min(1.0,dot(fdcolor.xyz,vec3(0.27, 0.67, 0.06))*2.0));//	0.5;
		//	ffresnel.x=fresnel0.x*min(1.0,dot(fdcolor.xyz,vec3(0.27, 0.67, 0.06))*2.0);//	0.5;
		#endif
	#endif

	#ifdef _HEIGHTMAP_
	
		float t=clamp(-pos.z*0.000025,0.0,1.0);
		fbcolor=texture2D(bmp0,texcoord.st*8.0);
		fbcolor.xy=(fbcolor.xy*2.0-1.0);
		fbcolor.z=sqrt(1.0-fbcolor.x*fbcolor.x-fbcolor.y*fbcolor.y);
		fnormal.z=sqrt(1.0-fnormal.x*fnormal.x-fnormal.y*fnormal.y);
		fnormal=fbcolor.xyz + fnormal;
		vec4 f0=pow(texture2D(dif0,texcoord.st*8.0),vec4(2.2));
		
		fbcolor.xyz=vec3(0.0,0.0,1.0);
		fnormal=mix(normalize(fnormal),fbcolor.xyz,vSlope);
		
		fdcolor=pow(texture2D(dif0,texcoord.st*dscale0+dofs0),vec4(2.2))*dcolor0;
		fdcolor=fdcolor*(1.0-t)+f0*t;
		
		vec4 baseColor=texture2D(baseTex,baseCoords);
		baseColor.rgb=pow(baseColor.rgb,vec3(2.2));
		fdcolor.xyz=mix(fdcolor.xyz,baseColor.xyz,vSlope);
		ffresnel.y=mix(ffresnel.y,baseColor.a,vSlope);
		
		// normalize resultant normal
		fnormal.z=sqrt(1.0-fnormal.x*fnormal.x-fnormal.y*fnormal.y);	
	
		vec3 one=vec3(1.0,1.0,1.0);
		vec3 maskColor=pow(texture2D(cmask,texcoord.st).rgb,vec3(2.2));
		vec3 rmul=fdcolor.rgb*maskColor;
		vec3 rscr=one-((one-maskColor)*(one-fdcolor.rgb));
		fdcolor.rgb=fdcolor.rgb*rscr+(one-fdcolor.rgb)*rmul;
		
	#endif

	#ifdef LAYER1
		
		fdcolor.xyz=mix(fdcolor.xyz,((vertColor.xyz*0.5)+fdcolor.xyz)*0.5,mask.r);
	
	#endif
	
	fdcolor.a=scatterlevel*scatterMask;
	
	#ifdef VEGETATION
		#ifndef BSET
			#ifndef MSET
				vec3 one=vec3(1.0,1.0,1.0);
				vec3 rmul=fdcolor.rgb*vgColor.xyz;
				vec3 rscr=one-((one-vgColor.xyz)*(one-fdcolor.rgb));
				fdcolor.rgb=fdcolor.rgb*rscr+(one-fdcolor.rgb)*rmul;
			#endif
		#endif
	#endif
	gl_FragData[0]=fdcolor;

	#ifdef PSYSTEM
			
		gl_FragData[1].xy=encode(vec3((fnormal.x*cosa)+(fnormal.y*sina),(fnormal.x*sina)-(fnormal.y*cosa),fnormal.z));
			
	#else
		
		#ifdef BSET
			
			vec3 one=vec3(1.0,1.0,1.0);
			vec3 rmul=gl_FragData[0].rgb*pcolor.xyz;
			vec3 rscr=one-((one-pcolor.xyz)*(one-gl_FragData[0].rgb));
			gl_FragData[0].rgb=gl_FragData[0].rgb*rscr+(one-gl_FragData[0].rgb)*rmul;
			gl_FragData[1].xy = encode(pnormal.xyz);
			
		#else
		
			#ifdef MSET
			vec3 one=vec3(1.0,1.0,1.0);
			vec3 rmul=gl_FragData[0].rgb*pcolor.xyz;
			vec3 rscr=one-((one-pcolor.xyz)*(one-gl_FragData[0].rgb));
			//gl_FragData[0].rgb=gl_FragData[0].rgb*rscr+(one-gl_FragData[0].rgb)*rmul;
			gl_FragData[0].rgb=mix(gl_FragData[0].rgb,gl_FragData[0].rgb*rscr+(one-gl_FragData[0].rgb)*rmul,terrainColorAmount);
			#else
				#ifdef SKINNING
				#else
					#ifdef _HEIGHTMAP_
					#else
						gl_FragData[0]*=occlusion; 
					#endif
				#endif
			#endif
		
			// normal
			gl_FragData[1].xy=encode(TBN*fnormal.xyz);
			
		#endif
			
	#endif
	
	//float lum=dot(fdcolor,vec3(0.27, 0.67, 0.06));
	
	gl_FragData[1].z=ffresnel.x;//*0.0625;
	gl_FragData[1].a=backScatter;//*scatterMask;
	
	// pos
	vec2 vel=((curpos.xy/curpos.w)-(prev.xy/prev.w))*vScale;
	
	// material params
	gl_FragData[2].r=matID;//scatterlevel*scatterMask; 
	gl_FragData[2].g=ffresnel.y/256;//*0.25; 
	gl_FragData[2].ba=(vel*vec2(0.5))+vec2(0.5);
}
